<?php

namespace Centraltest\LaravelSeeder;

use Centraltest\LaravelSeeder\Console\SeedScenarioCommand;
use Illuminate\Support\ServiceProvider;

class LaravelSeederServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        //
    }

    public function boot(): void
    {
        if($this->app->runningInConsole()) {
            //Function doesn't exist for Lumen
            if(function_exists('config_path')) {
                $this->publishes([
                    __DIR__.'/config/laravelseeder.php' => config_path('laravelseeder.php')
                ], 'laravelseeder_config');
            }
        }
    }
}
