<?php

namespace Centraltest\LaravelSeeder\Scenario;

/**
 * Base class for seeder scenarios
 */
abstract class Scenario
{
    /**
     * Company in which we will create seeder users
     *
     * @var int
     */
    protected int $motherCompanyId = 2;

    /**
     * Sub account in which we will create seeder users
     *
     * @var int
     */
    protected int $subAccountId = 300001;

    /**
     * Cache for scenario steps results
     */
    protected array $cache = [];

    /**
     * Constructor
     *
     * @param bool $fresh
     */
    protected bool $fresh;

    /**
     * @return array<ScenarioStep>
     */
    abstract protected function steps(): array;

    /**
     * @return array<ScenarioStep>|null
     */
    abstract protected function freshSteps(): ?array;

    /**
     * Constructor
     *
     * @param bool $fresh
     */
    public function __construct(bool $fresh = false)
    {
        $this->fresh = $fresh;
        $this->motherCompanyId = config('mother_company_id', 2);
        $this->subAccountId = config('sub_account_id', 300001);
    }

    /**
     * Execute the scenario
     *
     * @return void
     */
    public function run(): void
    {
        //Fresh database if needed
        if($this->fresh && $this->freshSteps() !== null) {
            $freshSteps = $this->freshSteps();
            foreach($freshSteps as $step) {
                //Run step
                $step->run();
            }
        }

        // Execute steps
        $steps = $this->steps();
        foreach($steps as $stepKey => $step) {
            //Update data from cache
            $step->updateDataFromCache($this->cache);

            //Run step
            dump("Step: $stepKey");
            $step->run();

            //Store in cache
            if($step->identifier() !== null && $step->result() !== null) {
                $this->cache[$step->identifier()] = $step->result();
            }
        }
    }
}
