<?php

namespace Centraltest\LaravelSeeder\Step;

/**
 * Scenario step for Eloquent model (with observers triggering)
 */
class ScenarioModelStep extends ScenarioStep
{
    protected string $modelName;

    /**
     * @param string $modelName
     * @param array $data
     * @param string|null $identifier
     */
    public function __construct(string $modelName, array $data, ?string $identifier = null)
    {
        parent::__construct($data, $identifier);
        $this->modelName = $modelName;
    }

    /**
     * @override
     * @return void
     */
    public function run(): void {
        // Create model instance and save to database
        $model = new $this->modelName();
        $model->fill($this->data);
        $model->save();

        // Update result
        $this->result = $model->toArray();
    }
}
