# Laravel Seeder

Helpers to define reusable database seeding scenarios for Laravel applications. Extracted from the `app/Console/Commands/SeederScenarios` helpers so they can be shared as a vendor package.

## What is inside
- `Scenario` orchestrates scenario steps and handles cache propagation between steps.
- `ScenarioStep` + concrete implementations for model inserts, raw table inserts, database cleanup, and (placeholder) factory inserts.
- Laravel service provider stub for future bindings or console commands.

## Usage
1. Require the package in your application (for local development you can use a path repository that points to `vendor/centraltest/laravel-seeder`).
2. Extend `Centraltest\LaravelSeeder\Scenario` and return an ordered list of `ScenarioStep` instances.
3. Optionally declare `freshSteps()` to clean tables before running the scenario.

```php
use Centraltest\LaravelSeeder\Scenario;
use Centraltest\LaravelSeeder\ScenarioFreshStep;
use Centraltest\LaravelSeeder\ScenarioStep;

class ParticipantsScenario extends Scenario
{
    protected function steps(): array
    {
        return [
            ScenarioStep::fromArray([
                'model' => \App\Models\Organisation::class,
                'data' => ['name' => 'Example Org'],
                'identifier' => 'organisation_1',
            ]),
            ScenarioStep::fromArray([
                'table' => 'campaigns',
                'data' => [
                    'name' => 'Avengers',
                    'organisation_id' => null,
                ],
                'data_cache' => [
                    'organisation_id' => ['organisation_1', 'id'],
                ],
            ]),
        ];
    }

    protected function freshSteps(): ?array
    {
        return [
            new ScenarioFreshStep([
                'organisations' => [['name', '=', 'Example Org']],
            ]),
        ];
    }
}
```

The `fromArray` helper understands `model`, `table`, and `factory` entries and wires cache references defined in `data_cache` before each step runs.
