<?php

namespace Centraltest\LaravelSeeder\Step;

use Illuminate\Support\Facades\DB;

/**
 * Scenario step to clean data
 */
class ScenarioFreshStep extends ScenarioStep
{
    /**
     * @param array $data
     * @param string|null $identifier
     */
    public function __construct(array $data, ?string $identifier = null)
    {
        parent::__construct($data, $identifier);
    }

    /**
     * @override
     * @return void
     */
    public function run(): void {
        // Clean database
        foreach($this->data as $table => $where) {
            DB::table($table)
                ->where($where)
                ->delete();
        }
    }
}
