<?php

namespace Centraltest\LaravelSeeder\Step;

use Illuminate\Support\Facades\DB;

/**
 * Scenario step for direct table insert
 */
class ScenarioTableStep extends ScenarioStep
{
    protected string $table;

    /**
     * @param string $table
     * @param array $data
     * @param string|null $identifier
     */
    public function __construct(string $table, array $data, ?string $identifier = null)
    {
        parent::__construct($data, $identifier);
        $this->table = $table;
    }

    /**
     * @override
     * @return void
     */
    public function run(): void
    {
        // Create model instance and save to database
        DB::table($this->table)->insert($this->data);
    }
}
